/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.rep.RException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public abstract class RClassSchema
implements Serializable {
    protected int classId;
    protected String className;
    protected int numOfProps;
    protected Hashtable indexHash = new Hashtable();
    protected Vector propNameVec = new Vector();
    protected Hashtable objHash = new Hashtable();
    protected int numOfKeys;
    protected int[] keyPos;
    protected int linkBase;
    protected int numOfLinks;
    protected Hashtable linkHash = new Hashtable();
    protected Hashtable assoHash = new Hashtable();

    protected RClassSchema() {
    }

    public int getNumOfProps() {
        return this.numOfProps;
    }

    public int getClassId() {
        return this.classId;
    }

    public int getNumOfKeys() {
        return this.numOfKeys;
    }

    public int getKeyPos(int n) {
        return this.keyPos[n];
    }

    public int getLinkBase() {
        return this.linkBase;
    }

    public int getNumOfLinks() {
        return this.numOfLinks;
    }

    public int getLinkedClassId(int n) {
        Integer n2 = (Integer)this.linkHash.get(new Integer(n));
        return n2;
    }

    public int getIndex(String string) throws RException {
        Integer n = (Integer)this.indexHash.get(string.toLowerCase());
        if (n == null) {
            System.out.println("[TX-REP]RClassSchema.getIndex - " + this.getClassName() + ":" + string + " not found");
            throw new RException("R_ERR_NOT_FOUND");
        }
        return n;
    }

    public void setIndex(String string, int n) {
        this.indexHash.put(string.toLowerCase(), new Integer(n));
        if (n >= this.propNameVec.size()) {
            this.propNameVec.setSize(n + 1);
        }
        this.propNameVec.setElementAt(string, n);
    }

    public String getClassName() {
        return this.className;
    }

    public Hashtable getIndexHash() {
        return this.indexHash;
    }

    public Vector getPropNameVec() {
        return this.propNameVec;
    }

    public Hashtable getObjHash() {
        return this.objHash;
    }

    public Hashtable getAssoHash() {
        return this.assoHash;
    }

    public int getAssoId(int n) {
        Integer n2 = (Integer)this.assoHash.get(new Integer(n));
        return n2;
    }

    public String getPropName(int n) {
        return (String)this.propNameVec.elementAt(n);
    }

    public boolean isKey(int n) {
        int n2 = 0;
        while (n2 < this.keyPos.length) {
            if (this.keyPos[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getKeyIndex(int n) {
        int n2 = 0;
        while (n2 < this.keyPos.length) {
            if (this.keyPos[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

